#include <iostream>
#include <vector>

using namespace std;

int br_cifara(unsigned long long int x) {

	int brojac = 0;

	while (x > 0) {
		x = x / 10;
		brojac++;
	}
	return brojac;
}

vector<int> cifre_u_niz(unsigned long long int x) {
    unsigned long long int y = x;
    
    int broj_cifara = br_cifara(x);
    vector<int> cifre(broj_cifara);
    for (int i = 0; i < broj_cifara; i++) {
        cifre[broj_cifara - 1 - i] = x % 10;
        x = x / 10;  
    }
    return cifre;
}

vector<int> spoji_dva_broja(unsigned long long int x, unsigned long long int y) {
    
    unsigned long long int duzi, kraci;

    if ( br_cifara(x) > br_cifara(y) ) {
        duzi = x;
        kraci = y;
    }
    else {
        duzi = y;
        kraci = x;
    }

    int duzinaduzeg = br_cifara(duzi);
    int duzinakraceg = br_cifara(kraci);
    
    vector<int> cifre_duzeg = cifre_u_niz(duzi);
    vector<int> cifre_kraceg_bez_nula = cifre_u_niz(kraci);
    
    vector<int> cifre_kraceg(duzinaduzeg);
    for (int i = 0; i < duzinaduzeg - duzinakraceg; i++) {
        cifre_kraceg[i] = -1;
    }
    for (int i = duzinaduzeg - duzinakraceg; i < duzinaduzeg; i++) {
        cifre_kraceg[i] = cifre_kraceg_bez_nula[i - duzinaduzeg + duzinakraceg];
    }

    vector<int> rezultat;
    
    // 64 5789
    // 0 0 9 4
    // 5 7 8 9
    // 5 7 9 9

    for (int i = 0; i < duzinaduzeg; i++) {
        if (cifre_duzeg[i] > cifre_kraceg[i]) {
            rezultat.push_back(cifre_duzeg[i]);
            continue;
        }
        if (cifre_duzeg[i] < cifre_kraceg[i]) {
            rezultat.push_back(cifre_kraceg[i]);
            continue;
        }
        if (cifre_duzeg[i] == cifre_kraceg[i]) {
            rezultat.push_back(cifre_duzeg[i]);
            rezultat.push_back(cifre_duzeg[i]);
            continue;
        }
    }

    return rezultat;
}

int main() 
{
    unsigned long long int x, y; 
    cin >> x >> y;
    vector<int> rezultat = spoji_dva_broja(x, y);
    for (int x : rezultat) {
        cout << x;
    }
    cout << endl;
    return 0;
}